# Таймлайн для Трекера

Таймлайн для Трекера – инструмент, позволяющий анализировать жизненный цикл тикетов проектов.

## Краткое описание возможностей Таймлайна для Трекера

В целом, на момент защиты проекта, приложение удовлетворяет основным требованиям, которые предоставил заказчик.

* **Просмотр полного списка тикетов.** Большинство проектов в Яндексе на сегодняшний день обладают большой историей разработки. При разработке мы постарались учесть этот фактор, и на данный момент Таймлан для Трекера способен отобразить более тысячи тикетов.
* **Поддержка языка запросов Трекера.** Выборка запрашиваемых тикетов может варьироваться. Таймлайн для Трекера поддерживает возможность пользовательского запроса на языке запросов Трекера, что позволит проанализировать отдельные временные участки проекта.
* **Выбор финальных статусов тикетов.** Для удобства работы с диаграммой, была введена возможность выбора финальных статусов тикетов. Это позволяет точно обозначить, в какой момент задачу можно считать решённой.
* **Copy-pastable URL.** Так как Таймлайн будет использоваться многими людьми, мы посчитали целесообразным реализовать возможность запускать приложение с определёнными заранее установленными параметрами. В нашем случае, мы храним информацию об изначальном пользоветельском запросе, финальных статусов, зуме в get параметрах URL.
* **Просмотр общей информации тикетах.** При наведении на иконку рядом с ключом тикета, появляется попап где можно посмотреть информацию об авторе тикета, исполнителе, проритетах а также о тегах.
* **Просмотр информации об изменении статусов одного тикета.** При наведении на столбец с диаграмой тикета, появляется попап где отражена история его изменений.
* **Просмотр сводной информации по всем тикетам на определенный момент времени.** При наведении на временную шкалу, появляется попап где отображена информация об изменениях статусов тикетов.

## Архитектура Таймлайна для Трекера

### Клиент
* **React**
* **Redux, Redux-thunk**
* **Axios**
* **CSS modules**

### Сервер
* **Convict**
* **Fastify**
* **Quick-lru**
* **Request**

### Инфрастуктура
* **Monorepo by yarn workspaces**
* **Sentry**
* **Trendbox**
* **Docker**

## Установка и запуск проекта

Для установки проекта необходимо склонировать репозиторий, или скачать исходный код проекта.

```sh

  # В корне проекта выполняем команду для установки зависимстей
  yarn

  # Для сборки файлов клиентской части приложения
  yarn build

  # Для старта приложения
  yarn start

```

После выполнения вышеприведённых команд, приложение станет доступным по адресу `http://localhost:8080/`

Для запуска клиентского приложения в режиме разработки с поддержкой HMR нужно выполнить `yarn dev`

## Автособранный стенд

[https://shri-rotoscoping-master.ui-development-school.yandex-team.ru/](https://shri-rotoscoping-master.ui-development-school.yandex-team.ru/)

