module.exports = (plop) => {
  const pascalCase = plop.getHelper('pascalCase')

  plop.setGenerator('component', {
    description: 'New component',
    prompts: [
      {
        type: 'input',
        name: 'name',
        message: 'What is your component name?'
      }
    ],
    actions: ({ name }) => [
      {
        type: 'add',
        path: 'src/components/{{pascalCase name}}/index.js',
        templateFile: '.plop/component/index'
      },
      {
        type: 'add',
        path: 'src/components/{{pascalCase name}}/{{pascalCase name}}.jsx',
        templateFile: '.plop/component/jsx'
      },
      {
        type: 'add',
        path: 'src/components/{{pascalCase name}}/{{pascalCase name}}.css',
        templateFile: '.plop/component/css'
      },
      ({ name }) => `New component created: ${pascalCase(name)}`
    ]
  })
}
