import axios from 'axios'

import * as TYPE from './types'
import { addErrorNotification } from './global'
import { ERRORS } from '../constants'

export const fetchStatusesStarted = () => ({
  type: TYPE.FETCH_STATUSES_START
})

export const fetchStatusesSuccess = (statuses) => ({
  type: TYPE.FETCH_STATUSES_SUCCESS,
  payload: {
    statuses
  }
})

export const fetchStatusesFail = (error) => ({
  type: TYPE.FETCH_STATUSES_FAIL,
  payload: {
    error
  }
})

export const setFinalStatuses = (selectedArr) => ({
  type: TYPE.SET_FINAL_STATUSES,
  payload: { selectedArr }
})

export const setDefaultFinalStatuses = (status) => ({
  type: TYPE.SET_DEFAULT_FINAL_STATUSES,
  payload: { status }
})

export const fetchStatuses = (defaultStatuses) => {
  return async (dispatch) => {
    dispatch(fetchStatusesStarted())

    try {
      const response = await axios.get('/statuses')
      const { data, error } = response.data

      if (error) {
        dispatch(addErrorNotification(error))
        dispatch(fetchStatusesFail(error))
      }

      if (data) {
        dispatch(fetchStatusesSuccess(data))

        if (defaultStatuses) {
          defaultStatuses = defaultStatuses.split(',').map(item => data[item])
          dispatch(setDefaultFinalStatuses(defaultStatuses))

          return
        }

        const closedStatus = Object.values(data).filter(sObj => {
          return (sObj.key === 'closed') || (sObj.key === 'resolved')
        })

        dispatch(setDefaultFinalStatuses(closedStatus))
      }
    } catch (e) {
      if (e.response && e.response.data && e.response.data.error) {
        dispatch(addErrorNotification(e.response.data.error))
      } else {
        console.error(e)
        dispatch(addErrorNotification(ERRORS.GENERIC_ERROR))
      }
      dispatch(fetchStatusesFail(e))
    }
  }
}
