import axios from 'axios'

import * as TYPE from './types'
import { addErrorNotification, setZoom } from './global'
import { setQueryError } from './query'

import errorCodes from '../../../server/dependences/errorCodes/codes'
import { ERRORS } from '../constants'

export const fetchTicketsStarted = () => ({
  type: TYPE.FETCH_TICKETS_START
})

export const fetchTicketsSuccess = (tickets) => ({
  type: TYPE.FETCH_TICKETS_SUCCESS,
  payload: {
    tickets
  }
})

export const fetchTicketsFail = () => ({
  type: TYPE.FETCH_TICKETS_FAIL
})

export const fetchTickets = (query = '', finalStatus = [], isInitial = false) => {
  return async (dispatch) => {
    if (!isInitial) {
      dispatch(setZoom(0))
    }

    dispatch(fetchTicketsStarted())

    try {
      const response = await axios.post('/task-list', {
        query,
        finalStatus
      })

      const { data, error } = response.data

      if (error) {
        dispatch(addErrorNotification(error))
        if (error === errorCodes.UNPROCESSABLE_QUERY) { dispatch(setQueryError(error)) }
      }

      if (data) {
        if (Array.isArray(data) && data.length && error) {
          dispatch(addErrorNotification(errorCodes.PARTIAL_OUTPUT))
        }
        dispatch(fetchTicketsSuccess(data))
      }
    } catch (e) {
      if (e.response && e.response.data && e.response.data.error) {
        dispatch(addErrorNotification(e.response.data.error))
      } else {
        console.error(e)
        dispatch(addErrorNotification(ERRORS.GENERIC_ERROR))
      }
      dispatch(fetchTicketsFail())
    }
  }
}
