import React from 'react'
import { connect } from 'react-redux'
import throttle from 'raf-throttle'

import * as globalSelectors from '../../selectors/global'
import * as globalActions from '../../actions/global'

import s from './Controls.css'

const mapStateToProps = (state) => ({
  zoom: globalSelectors.getOriginalZoom(state)
})

const mapDispatchToProps = (dispatch) => ({
  setZoom: (zoom) => {
    dispatch(globalActions.setZoom(zoom))
  }
})

class Controls extends React.Component {
  componentWillUnmount () {
    this.changeZoom.cancel()
  }

  onChange = (e) => {
    this.changeZoom(e.currentTarget.value)
  }

  changeZoom = throttle((value) => {
    this.props.setZoom(value)
  })

  render () {
    const { zoom } = this.props

    return (
      <div className={s.controls}>
        <label htmlFor="zoom">Zoom</label>
        <svg width="14" height="14" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M.36 28.6l7-7c-4.5-5-4.3-12.8.5-17.6 5-5 13.2-5 18.2 0a12.92 12.92 0 01-9.1 22c-3.1 0-6.1-1.1-8.5-3.3l-7 7c-.1.1-.3.2-.5.2s-.4-.1-.5-.2c-.4-.4-.4-.8-.1-1.1zm24.6-7.6c4.4-4.4 4.4-11.6 0-16.1-2.2-2.2-5.1-3.3-8-3.3-2.9 0-5.8 1.1-8 3.3-4.4 4.4-4.4 11.6 0 16.1 4.4 4.5 11.6 4.5 16 0z" fill="#000"/><path d="M12.36 12.3h9.2c.4 0 .8.3.8.8s-.3.8-.8.8h-9.2c-.4 0-.8-.3-.8-.8s.4-.8.8-.8z" fill="#000"/></svg>
        <input
          className={s.range}
          name="zoom"
          type="range"
          value={zoom}
          min="0"
          max="1"
          step="0.005"
          onChange={this.onChange}
        />
        <svg width="14" height="14" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M.36 28.6l7-7c-4.5-5-4.3-12.8.5-17.6 5-5 13.2-5 18.2 0a12.92 12.92 0 01-9.1 22c-3.1 0-6.1-1.1-8.5-3.3l-7 7c-.1.1-.3.2-.5.2s-.4-.1-.5-.2c-.4-.4-.4-.8-.1-1.1zm24.6-7.6c4.4-4.4 4.4-11.6 0-16.1-2.2-2.2-5.1-3.3-8-3.3-2.9 0-5.8 1.1-8 3.3-4.4 4.4-4.4 11.6 0 16.1 4.4 4.5 11.6 4.5 16 0z" fill="#000"/><path d="M12.36 12.3h3.8V8.5c0-.4.3-.8.8-.8s.8.3.8.8v3.8h3.8c.4 0 .8.3.8.8s-.3.8-.8.8h-3.8v3.8c0 .4-.3.8-.8.8s-.8-.3-.8-.8v-3.8h-3.8c-.4 0-.8-.3-.8-.8s.4-.8.8-.8z" fill="#000"/></svg>
      </div>
    )
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Controls)
