import React from 'react'
import Popup from 'reactjs-popup'
import { connect } from 'react-redux'

import join from '../../utils/join'
import { getTicketList } from '../../selectors/tickets'
import { getFinalStatuses } from '../../selectors/statuses'
import TicketInfo from '../TicketInfo'

import s from './LeftPanel.css'

const mapStateToProps = state => ({
  tickets: getTicketList(state),
  finalStatuses: getFinalStatuses(state)
})

class LeftPanel extends React.Component {
  render () {
    const { tickets, finalStatuses } = this.props

    return (
      <div className={s.panel}>
        {tickets.map(t => {
          const { changelog } = t
          const lastStatus = changelog.slice(-1)[0]
          const isFinished = finalStatuses.some(fs => fs.id === (lastStatus && +lastStatus.id))

          return (
            <div className={join(s['key-wrapper'], isFinished ? s.__is_finished : s.__in_progress)} key={t.key}>
              <a
                className={s.key}
                href={t.url}
                target="_blank"
                rel="noopener noreferrer"
                title={t.key}
              >{t.key}</a>
              <Popup
                trigger={
                  <svg className={s['key-info']} xmlns="http://www.w3.org/2000/svg" viewBox="0 0 330 330">
                    <path
                      d="M165 0C74.02 0 0 74.02 0 165s74.02 165 165 165 165-74.02 165-165S255.98 0 165 0zm0 300c-74.44 0-135-60.56-135-135S90.56 30 165 30s135 60.56 135 135-60.56 135-135 135z"/>
                    <path
                      d="M165 70c-11.03 0-20 8.98-20 20 0 11.03 8.97 20 20 20 11.02 0 20-8.97 20-20 0-11.02-8.98-20-20-20zM165 140a15 15 0 00-15 15v90a15 15 0 0030 0v-90a15 15 0 00-15-15z"/>
                  </svg>
                }
                position={['right top', 'right bottom']}
                offsetX={2}
                on="hover"
                keepTooltipInside={true}
                contentStyle={{
                  zIndex: 'var(--z-index-ticket-info-popup)',
                  padding: 'var(--space-xs)',
                  border: 'none',
                  borderRadius: '3px',
                  backgroundColor: 'var(--popup-bg)'
                }}
                arrow={false}
              >
                <TicketInfo ticket={t}/>
              </Popup>
            </div>)
        })}
      </div>
    )
  }
}

export default connect(mapStateToProps)(LeftPanel)
