import React from 'react'

import { scrollBarWidth, leftPanelPadding } from '../../constants'

import s from './Marker.css'

class Marker extends React.Component {
  render () {
    const { position, hasWidgetVerticalScroll } = this.props

    const initLeft = hasWidgetVerticalScroll
      ? `calc(100% - ${leftPanelPadding * 2}px)`
      : `calc(100% - ${leftPanelPadding * 2}px - ${scrollBarWidth}px)`

    return (
      <div
        className={s.marker}
        style={{
          left: position === null ? initLeft : 0,
          transform: `translateX(${position || 0}px)`
        }}
        // data-current={DateTime.fromJSDate(markerTime).toFormat('HH:mm d MMM yy')}
      >
      </div>
    )
  }
}

export default Marker
