import React from 'react'

import s from './MarkerPopup.css'

class MarkerPopup extends React.Component {
  constructor (props) {
    super(props)
    this.markerPopup = React.createRef()

    this.state = {
      isPopupNearRightBoundaries: false,
      isPopupNearBottomBoundaries: false,
      popupWidth: 0,
      popupHeight: 0
    }
  }

  componentDidUpdate (prevProps, prevState) {
    if (!this.markerPopup || !this.markerPopup.current) return

    const { boundaries: { right, bottom }, position: { x, y } } = this.props

    const isTicketChanged = this.props.ticketId !== prevProps.ticketId
    const { width, height } = isTicketChanged
      ? this.markerPopup.current.getBoundingClientRect()
      : { width: this.state.popupWidth, height: this.state.popupHeight }

    const isNearRight = right - x < Math.round(width)
    const isNearBottom = bottom - y < height

    if (
      prevState.isPopupNearRightBoundaries !== isNearRight ||
      prevState.isPopupNearBottomBoundaries !== isNearBottom ||
      width !== prevState.popupWidth ||
      height !== prevState.popupHeight
    ) {
      this.setState({
        isPopupNearRightBoundaries: isNearRight,
        isPopupNearBottomBoundaries: isNearBottom,
        popupWidth: width,
        popupHeight: height
      })
    }
  }

  render () {
    const { position, markerTime, children } = this.props
    const { isPopupNearRightBoundaries, isPopupNearBottomBoundaries, popupWidth, popupHeight } = this.state

    if (!children || !children.filter(Boolean).length) return null

    const left = !isPopupNearRightBoundaries ? position.x + 4 : (position.x - 4 - popupWidth)
    const top = !isPopupNearBottomBoundaries ? position.y : (position.y - popupHeight)

    return (
      <div
        className={s.popup}
        style={{ left, top }}
        ref={this.markerPopup}
      >
        <div className={s.time}>{markerTime}</div>
        {/* pos: {position.x} : {position.y} */}
        {children}
      </div>
    )
  }
}

export default MarkerPopup
