import React from 'react'
import Input from '../Input'

import s from './QueryInput.css'

const QueryInput = ({ value, disabled, error, onKeyPress, onChange, onClearPressed }) => {
  return <div className={s.QueryInput}>
    {value && <div className={s.Status} style={{ backgroundColor: error ? 'var(--text-accent)' : 'var(--emerald)' }}></div>}

    <Input
      placeholder="Query: задайте фильтр с помощью языка запросов"
      id="query"
      value={value}
      disabled={disabled}
      onChange={onChange}
      onKeyPress={onKeyPress}
    />

    <button onClick={onClearPressed} disabled={disabled} className={s.ClearButton}>
      <svg className={s.ClearIcon} height="20" width="20" viewBox="0 0 20 20" aria-hidden="true">
        <path d="M14.348 14.849c-0.469 0.469-1.229 0.469-1.697 0l-2.651-3.030-2.651 3.029c-0.469 0.469-1.229 0.469-1.697 0-0.469-0.469-0.469-1.229 0-1.697l2.758-3.15-2.759-3.152c-0.469-0.469-0.469-1.228 0-1.697s1.228-0.469 1.697 0l2.652 3.031 2.651-3.031c0.469-0.469 1.228-0.469 1.697 0s0.469 1.229 0 1.697l-2.758 3.152 2.758 3.15c0.469 0.469 0.469 1.229 0 1.698z"></path>
      </svg>
    </button>
  </div>
}

export default QueryInput
