import React from 'react'
import Tick from '../Tick'
import * as scaleUtils from '../../utils/scaleUtils'
import { minWidth } from '../../constants'

import s from './Scale.css'

class Scale extends React.PureComponent {
  render () {
    const { scaleRef, scale, scaleWidth, from, to } = this.props
    const ticks = scaleUtils.getTicks(scale, from, to)
    const fromTick = ticks.shift()
    const toTick = ticks.pop()
    const [firstTick] = ticks
    const lastTick = ticks.pop()
    const minTickWidth = minWidth[firstTick.interval]
    // дистанция в пикселях
    const distanceBetweenFromAndFirstTick = firstTick.position - fromTick.position
    // подписи у fromTick будут скрыты
    const isStartWithoutLabel = distanceBetweenFromAndFirstTick < minTickWidth
    const distanceBetweenLastAndToTick = toTick.position - lastTick.position
    // если короткий последний период, то прячем нижнюю подпись у lastTick
    // и средннюю у toTick
    const isShortLastPeriod = distanceBetweenLastAndToTick < minTickWidth

    return (
      <div className={s.root}>
        <div
          id="timeline"
          ref={scaleRef}
          className={s.timeline}
          style={{ width: scaleWidth }}
        >
          <Tick
            tick={fromTick}
            noTop={isStartWithoutLabel}
            noMiddle={isStartWithoutLabel}
            noBottom={isStartWithoutLabel}
          />
          {ticks.map((tick) => {
            return <Tick key={tick.key} tick={tick} />
          })}
          <Tick tick={lastTick} noBottom={isShortLastPeriod} />
          <Tick tick={toTick} noMiddle={isShortLastPeriod} />
        </div>
      </div>
    )
  }
}

export default Scale
