import React from 'react'
import throttle from 'raf-throttle'
import EventListener from 'react-event-listener'
import s from './Scrollbar.css'

class Scrollbar extends React.Component {
  constructor (props) {
    super(props)
    this.state = {
      isDragging: false,
      dragPosition: null,
      realDelta: 0
    }
    window.changePosition = this.changePosition
  }

  componentWillUnmount () {
    this.changePosition.cancel()
  }

  handleMouseDown = e => {
    this.setState({
      isDragging: true,
      dragPosition: e.clientX,
      shift: this.props.shift
    })
  }

  handleMouseUp = e => {
    this.setState({
      isDragging: false,
      dragPosition: null
    })
  }

  handleMouseMove = e => {
    if (!this.state.isDragging) {
      return
    }
    const { clientX } = e
    this.changePosition({ clientX })
  }

  changePosition = throttle(({ clientX }) => {
    const { from, shiftedFrom, originalScale, onChange } = this.props
    if (!this.state.isDragging || from === shiftedFrom) {
      return
    }
    const realDelta = clientX - this.state.dragPosition
    const sign = realDelta < 0 ? -1 : 1
    const fromInMs = +from
    const realDeltaInMs = +originalScale.invert(Math.abs(realDelta))
    const realDeltaDurationInMs = realDeltaInMs - fromInMs
    onChange(this.state.shift + realDeltaDurationInMs * sign)
  })

  render () {
    const { width, offset } = this.props
    return (
      <div
        className={s.scrollbar}
        onMouseDown={this.handleMouseDown}
      >
        <EventListener
          target="window"
          onMouseMove={this.handleMouseMove}
          onMouseUp={this.handleMouseUp}
          onMouseLeave={this.handleMouseUp}
        />
        <div
          className={s.thumb}
          style={{
            width,
            transform: `translateX(${offset}px)`
          }}
        />
      </div>
    )
  }
}

export default Scrollbar
