import React from 'react'
import Select from 'react-select'

import MultiValueContainer from '../MultiValueContainer'

import s from './Select.css'

const customStyles = {
  valueContainer: (provided) => ({
    ...provided,
    display: 'block',
    flexWrap: 'nowrap',
    whiteSpace: 'nowrap',
    textOverflow: 'ellipsis'
  }),
  control: (provided) => ({
    ...provided,
    borderRadius: 'var(--input-border-radius)',
    minHeight: 34,
    cursor: 'pointer'
  }),
  clearIndicator: (provided) => ({
    ...provided,
    padding: '7px 8px'
  }),
  dropdownIndicator: (provided) => ({
    ...provided,
    padding: '7px 8px'
  }),
  menu: (provided) => ({
    ...provided,
    boxSizing: 'border-box'
  })
}

class MultiSelect extends React.Component {
  render () {
    const { options, value, className = '', onChange, disabled } = this.props

    return (
      <>
        <span className={s.selectLabel}>Статусы, когда таски считаются завершенными</span>
        <Select
          placeholder="Выберите финальные статусы"
          className={className}
          closeMenuOnSelect={false}
          components={{ MultiValueContainer }}
          isDisabled={disabled}
          value={value}
          isMulti={1}
          isSearchable={false}
          isOpen={true}
          options={options}
          onChange={onChange}
          hideSelectedOptions={false}
          styles={customStyles}
        />
      </>
    )
  }
}

export default MultiSelect
