import React from 'react'
import { connect } from 'react-redux'
import { DateTime } from 'luxon'

import { getTicketById } from '../../selectors/tickets'
import { getFinalStatuses, getStatusList } from '../../selectors/statuses'
import { shortRuHumanizer } from '../../utils/shortRuHumanizer'

import s from './TaskChangelogStatistic.css'

const mapStateToProps = (state, ownProps) => {
  return {
    ticket: getTicketById(state, ownProps.ticketIdHovered),
    statuses: getStatusList(state),
    finalStatuses: getFinalStatuses(state)
  }
}

class TaskChangelogStatistic extends React.Component {
  render () {
    const { ticket, to, statuses, finalStatuses } = this.props

    if (!ticket) return null

    return (
      <>
        {
          ticket.changelog.map((changeObj, i, changelog) => {
            const { updatedAt, id, status } = changeObj

            const updatedTo = changelog[i + 1] ? DateTime.fromMillis(changelog[i + 1].updatedAt) : DateTime.fromJSDate(to)
            const at = DateTime.fromMillis(updatedAt)
            const statusDuration = updatedTo.diff(at).toObject()
            let humDuration = shortRuHumanizer(
              statusDuration.milliseconds,
              { largest: 2, spacer: '', round: true, units: ['y', 'mo', 'w', 'd', 'h', 'm', 's'] }
            )

            if (finalStatuses.some(fs => fs.key === status) && i === (changelog.length - 1)) {
              humDuration = null
            }

            return (
              <div key={i} className={s.statusLine}>
                <div className={s.statusPoint} style={{ backgroundColor: (statuses[id] || statuses[1]).color }} />
                <div className={s.date}>{at.toFormat('dd')}.{at.toFormat('MM')}  {humDuration && `(${humDuration})`}</div>
                <div className={s.statusName}>{(statuses[id] || statuses[1]).name}</div>
              </div>
            )
          })
        }
      </>
    )
  }
}

export default connect(mapStateToProps)(TaskChangelogStatistic)
