import React from 'react'
import { connect } from 'react-redux'

import { getStatisticByMarkerTime } from '../../selectors/tickets'
import { getStatusList } from '../../selectors/statuses'

import s from './TaskStatusesByTimeStatistic.css'

const mapStateToProps = (state, ownProps) => {
  return {
    statisticByMarkerTime: getStatisticByMarkerTime(state, ownProps.markerTime),
    statuses: getStatusList(state)
  }
}

class TaskStatusesByTimeStatistic extends React.Component {
  render () {
    const { statisticByMarkerTime, statuses } = this.props

    if (!statisticByMarkerTime) return null

    return (
      <>
        {
          Object.entries(statisticByMarkerTime)
            .map(([key, value]) => (
              <div key={key} className={s.statusLine}>
                <div className={s.statusPoint} style={{ backgroundColor: statuses[key].color }} />
                <div className={s.statusName}>{ statuses[key].name }</div>
                <div className={s.count}>{value}</div>
              </div>
            ))
        }
      </>
    )
  }
}

export default connect(mapStateToProps)(TaskStatusesByTimeStatistic)
