import React from 'react'

import join from '../../utils/join'
import firstLetterToUpperCase from '../../utils/firstLetterToUpperCase'

import s from './Tick.css'

class Tick extends React.PureComponent {
  render () {
    const { tick, noTop, noMiddle, noBottom } = this.props
    return (
      <div
        className={s.tick}
        style={{ transform: `translateX(${tick.position}px)` }}
        data-key={tick.key}
      >
        {tick.top && <div key="top" className={join(s.top, noTop && s.hidden)}>{firstLetterToUpperCase(tick.top)}</div>}
        {tick.middle && <div key="middle" className={join(s.middle, noMiddle && s.hidden)}>{firstLetterToUpperCase(tick.middle)}</div>}
        {tick.bottom && <div key="bottom" className={join(s.bottom, noBottom && s.hidden)}>{firstLetterToUpperCase(tick.bottom)}</div>}
      </div>
    )
  }
}

export default Tick
