import React from 'react'
import { connect } from 'react-redux'

import { getTicketList } from '../../selectors/tickets'
import { getStatusList, getFinalStatuses } from '../../selectors/statuses'
import { minStatusWidth } from '../../constants'
import join from '../../utils/join'

import s from './TicketContainer.css'

const mapStateToProps = state => ({
  tickets: getTicketList(state),
  statuses: getStatusList(state),
  finalStatuses: getFinalStatuses(state)
})

class TicketContainer extends React.PureComponent {
  render () {
    const { tickets, scale, to, scaleWidth, statuses, finalStatuses, isDragging } = this.props

    if (Object.keys(statuses).length === 0) {
      return null
    }

    return (
      <div className={join(s.root, isDragging && s.root_dragging)} id="tickets-container">
        {tickets.map(t => {
          const { changelog } = t
          const lastStatus = changelog.slice(-1)[0]
          const isFinished = finalStatuses.some(fs => fs.id === (lastStatus && +lastStatus.id))

          return (
            <div
              key={t.key}
              className={join('ticket-line', s.ticketLine, isFinished ? s.__is_finished : s.__in_progress)}
              style={{ width: scaleWidth }}
              data-ticket-id={t.id}
            >
              <div className={s.title}>{t.title}</div>
              {changelog.map((changeObj, i, changelog) => {
                const { updatedAt, id } = changeObj
                const updatedTo = changelog[i + 1] ? changelog[i + 1].updatedAt : new Date(to).getTime()

                let width = scale(updatedTo) - scale(updatedAt)
                // если ширина очень маленькая - ставим 5px и отображаем с z-index,
                // чтобы не потерялся статус на шкале
                const originalWidth = width
                width = width < minStatusWidth ? minStatusWidth : width

                // если статус из финальных - ставим ему тоже мин ширину
                // только если статус последний в цепочке changelog
                if (finalStatuses.some(fs => fs.id === +id) && i === (changelog.length - 1)) {
                  width = minStatusWidth
                }

                return (
                  <div
                    key={i}
                    className={s.status}
                    style={{
                      left: scale(updatedAt),
                      backgroundColor: (statuses[id] || statuses[1]).color,
                      transform: originalWidth <= 1 && 'translateX(-50%)',
                      width: width,
                      zIndex: width <= minStatusWidth ? 2 : 1
                    }}
                  >
                  </div>

                )
              })}
            </div>)
        })}
      </div>
    )
  }
}

export default connect(mapStateToProps)(TicketContainer)
