import React from 'react'
import { useSelector } from 'react-redux'
import { DateTime } from 'luxon'

import { shortRuHumanizer } from '../../utils/shortRuHumanizer'
import { getStatusList } from '../../selectors/statuses'

import classes from './TicketInfo.css'

const TicketInfo = ({ ticket }) => {
  const now = DateTime.local()
  const statusStartTime = DateTime.fromMillis(ticket.statusStartTime)
  const diff = now.diff(statusStartTime).toObject()
  const diffDisplay = shortRuHumanizer(diff.milliseconds, { largest: 2, spacer: '' })

  const statuses = useSelector(getStatusList)

  return (
    <div className={classes.TicketInfo}>
      {ticket.createdBy &&
        <>
          <div className={classes['TicketInfo-Property']}>Автор</div>
          <div className={classes['TicketInfo-Value']}>
            <span className={classes.Username}>{ticket.createdBy.display}</span>
          </div>
        </>
      }
      {ticket.assignee &&
        <>
          <div className={classes['TicketInfo-Property']}>Исполнитель</div>
          <div className={classes['TicketInfo-Value']}>
            <span className={classes.Username}>{ticket.assignee.display}</span>
          </div>
        </>
      }
      {ticket.priority &&
      <>
        <div className={classes['TicketInfo-Property']}>Приоритет</div>
        <div className={classes['TicketInfo-Value']}>{ticket.priority}</div>
      </>
      }
      <div className={classes['TicketInfo-Property']}>Статус</div>
      <div className={classes['TicketInfo-Value']}>{statuses[ticket.statusId].name} {diffDisplay && diffDisplay}</div>
      {ticket.tags &&
        <>
          <div className={classes['TicketInfo-Property']}>Теги</div>
          <div className={classes['TicketInfo-Value']}>
            {ticket.tags.map((tag, i) => <span key={i}>{tag}</span>)}
          </div>
        </>
      }
    </div>
  )
}

export default TicketInfo
