import { timeYear, timeMonth, timeWeek, timeDay, timeHour, timeMinute } from 'd3-time'

export const INTERVALS = {
  m5: timeMinute.every(5),
  m15: timeMinute.every(15),
  m30: timeMinute.every(30),
  h: timeHour,
  h6: timeHour.every(6),
  h12: timeHour.every(12),
  d: timeDay,
  w: timeWeek,
  m: timeMonth,
  y: timeYear
}

export const ERRORS = {
  GENERIC_ERROR: 'GENERIC_ERROR',
  ERROR_IN_FILTER_QUERY: 'Ошибка в запросе на языке запросов Трекера'
}

export const dataFetchingStates = {
  loading: 0,
  success: 1,
  fail: 2,
  disabled: 3
}

export const leftPanelWidth = 200
export const minStatusWidth = 6
export const appPadding = 0
export const leftPanelPadding = 20
export const scrollBarWidth = 16

export const minWidth = {
  m5: 54,
  m15: 54,
  m30: 54,
  h: 54,
  h6: 54,
  h12: 54,
  d: 54,
  w: 54,
  m: 100,
  y: 60
}

export const MIN_SIZE = new Map([
  [INTERVALS.m5, minWidth.m5],
  [INTERVALS.m15, minWidth.m15],
  [INTERVALS.m30, minWidth.m30],
  [INTERVALS.h, minWidth.h],
  [INTERVALS.h6, minWidth.h6],
  [INTERVALS.h12, minWidth.h12],
  [INTERVALS.d, minWidth.d],
  [INTERVALS.w, minWidth.w],
  [INTERVALS.m, minWidth.m],
  [INTERVALS.y, minWidth.y]
])
