import errorCodes from '../../server/dependences/errorCodes/codes'
import { ERRORS } from './constants'

export default (code) => {
  const messages = {
    [errorCodes.ACCESS_DENIED]: {
      title: 'Доступ запрещен',
      message: 'У вас нет прав доступа на просмотр задач организации'
    },
    [errorCodes.AUTH_FAILED]: {
      title: 'Ошибка аутентификации',
      message: 'Необходимо выполнить вход в приложение'
    },
    [errorCodes.PARTIAL_OUTPUT]: {
      title: 'Неполный вывод данных',
      message: 'Лавина судьбы накрыла наше приложение с головой. Суровые времена настали в королевстве. Отважные рыцари кода к сожалению ничего уже не могут поделать со свершившимся. Потрачено.\n А на самом деле, по техническим причинам не удается получить часть запросов от трекера'
    },
    [errorCodes.TOO_MANY_REQUESTS_TO_TRACKER_API]: {
      title: 'Слишком много апи запросов',
      message: 'Превышен лимит запросов к трекеру'
    },
    [errorCodes.TRACKER_API_ROUTE_NOT_AVAILABLE]: {
      title: 'Недоступно api трекера',
      message: 'Возможны проблемы с сетью или трекер временно не отвечает'
    },
    [errorCodes.UNEXPECTED_ERROR]: {
      title: 'Непредвиденная ошибка',
      message: 'Более подробная информация об ошибке содержится в логе веб-сервера'
    },
    [ERRORS.GENERIC_ERROR]: {
      title: 'Непредвиденная ошибка',
      message: 'Более подробная информация об ошибке содержится в консоли браузера'
    },
    [errorCodes.UNPROCESSABLE_QUERY]: {
      title: 'Ошибка запроса',
      message: 'Трекер не может обработать введенный запрос'
    },
    [errorCodes.PAGINATON_CURSOR_FAILED]: {
      title: 'Не удалось получить весь список задач',
      message: 'Слишком долгое время ожидания между запросами'
    }
  }

  return messages[code] || messages[errorCodes.UNEXPECTED_ERROR]
}
