import React from 'react'
import { render } from 'react-dom'
import { Provider } from 'react-redux'
import { Settings } from 'luxon'
// import * as Sentry from '@sentry/browser'

import App from './components/App'
import { store } from './store/configureStore'

import './css/index.css'

// Sentry.init({
//   dsn: 'http://7745b117310243e2adc1276c99b1fc80@95.169.184.150:9000/3'
// })

Settings.defaultLocale = 'ru-RU'

const MainApp = () => {
  return (
    <Provider store={store}>
      <App />
    </Provider>
  )
}

const rootElement = document.getElementById('root')
render(<MainApp />, rootElement)
