import bezierEasing from 'bezier-easing'
import * as TYPE from '../actions/types'

// https://cubic-bezier.com/#.21,1.08,.73,.99
const easing = bezierEasing(0.21, 1.08, 0.73, 0.99)

let zoomFromURL

if (window.location.search) {
  const searchParams = new URLSearchParams(window.location.search)
  zoomFromURL = searchParams.get('zoom')
}

const INITIAL_STATE = {
  zoomOriginal: zoomFromURL || 0,
  zoom: easing(zoomFromURL)
}

export default function (state = INITIAL_STATE, action) {
  switch (action.type) {
    case TYPE.SET_ZOOM:
      return {
        ...state,
        zoomOriginal: +action.payload.zoom,
        zoom: easing(+action.payload.zoom)
      }

    case TYPE.CHANGE_ZOOM: {
      return {
        ...state,
        zoomOriginal: action.payload.zoom,
        zoom: easing(action.payload.zoom)
      }
    }

    default:
      return state
  }
}
