import * as TYPE from '../actions/types'
import { dataFetchingStates } from '../constants'

const INITIAL_STATE = {
  statuses: {},
  status: dataFetchingStates.success,
  finalStatuses: [],
  isInitialStatusesLoaded: false
}

export default (state = INITIAL_STATE, action) => {
  switch (action.type) {
    case TYPE.FETCH_STATUSES_START:
      return {
        ...state,
        status: dataFetchingStates.loading
      }

    case TYPE.FETCH_STATUSES_SUCCESS:
      return {
        ...state,
        statuses: action.payload.statuses,
        status: dataFetchingStates.success
      }

    case TYPE.FETCH_STATUSES_FAIL:
      return {
        ...state,
        statuses: {},
        status: dataFetchingStates.fail,
        isInitialStatusesLoaded: true
      }

    case TYPE.SET_DEFAULT_FINAL_STATUSES:
      return {
        ...state,
        finalStatuses: [...action.payload.status],
        isInitialStatusesLoaded: true
      }

    case TYPE.SET_FINAL_STATUSES:

      const selectedArr = action.payload.selectedArr || []
      const finalStatuses = selectedArr.length > 0
        ? selectedArr.map(selectedStatus => {
          const { value } = selectedStatus
          return Object.values(state.statuses).find(s => s.key === value)
        })
        : selectedArr

      return {
        ...state,
        finalStatuses
      }

    default:
      return state
  }
}
