import * as TYPE from '../actions/types'
import { dataFetchingStates } from '../constants'

const INITIAL_STATE = {
  tickets: [],
  status: dataFetchingStates.success,
  isWasRequest: false
}

function prependOpenStatusToChangelog (ticket) {
  return {
    ...ticket,
    statusId: ticket.changelog.length
      ? ticket.changelog[ticket.changelog.length - 1].id
      : 1,
    statusStartTime: ticket.changelog.length
      ? ticket.changelog[ticket.changelog.length - 1].updatedAt
      : ticket.createdAt,
    changelog: [
      { id: 1, key: 'open', updatedAt: ticket.createdAt },
      ...ticket.changelog
    ]
  }
}

export default (state = INITIAL_STATE, action) => {
  switch (action.type) {
    case TYPE.DISABLE_FORM:
      return {
        ...state,
        status: dataFetchingStates.disabled
      }

    case TYPE.FETCH_TICKETS_START:
      return {
        ...state,
        isWasRequest: true,
        status: dataFetchingStates.loading
      }

    case TYPE.FETCH_TICKETS_SUCCESS:
      return {
        ...state,
        tickets: action.payload.tickets
          .map(prependOpenStatusToChangelog),
        status: dataFetchingStates.success
      }

    case TYPE.FETCH_TICKETS_FAIL:
      return {
        ...state,
        tickets: [],
        status: dataFetchingStates.fail
      }

    default:
      return state
  }
}
