const getStatuses = state => state.statuses

export const getStatusesStatus = state => {
  return getStatuses(state).status
}

export const getStatusList = state => {
  return getStatuses(state).statuses
}

export const getStatusesForSelect = state => {
  const statuses = getStatusList(state)

  return Object.values(statuses).map(status => {
    return {
      id: status.id,
      value: status.key,
      label: status.name
    }
  })
}

export const getFinalStatuses = state => {
  return getStatuses(state).finalStatuses
}

export const getFinalStatusesForSelect = state => {
  return getFinalStatuses(state).map(s => ({
    id: s.id,
    value: s.key,
    label: s.name
  }))
}
