import { getFinalStatuses } from './statuses'

const getTickets = state => state.tickets
const getStatuses = state => state.statuses

export const getTicketsStatuses = state => {
  return getStatuses(state).statuses
}

export const getTicketsStatus = state => {
  return getTickets(state).status
}

export const getTicketList = state => {
  return getTickets(state).tickets
}

export const getTicketById = (state, id) => {
  return id ? getTicketList(state).find(t => t.id === id) : null
}

export const getSortedTicketsByCreatedDate = state => {
  const tickets = getTicketList(state)
  return tickets.length ? tickets.slice().sort((t1, t2) => t1.createdAt - t2.createdAt) : tickets
}

export const getIsWasRequest = state => getTickets(state).isWasRequest

export const getDateTo = state => {
  const tickets = getSortedTicketsByCreatedDate(state)
  if (!tickets.length) return null

  const finalStatusesId = getFinalStatuses(state).map(fs => fs.id)

  // Если есть незавершенные тикеты - то дата будет now
  const actualTickes = tickets.filter(t => !finalStatusesId.includes(+t.statusId))

  if (actualTickes.length > 0) return Date.now()

  // если только тикеты, которые считаются завершенными, то
  // возьмем max дату, когда они получили финальный статус
  const closedTicketsStatusDates = tickets.filter(t => finalStatusesId.some(fsId => fsId === +t.statusId))
    .map(ct => ct.statusStartTime)
    .filter(Boolean)

  return closedTicketsStatusDates.length > 0 ? Math.max(...closedTicketsStatusDates) : Date.now()
}

export const getDateFrom = (state) => {
  const tickets = getSortedTicketsByCreatedDate(state)
  if (!tickets.length) return null

  return tickets[0].createdAt
}

export const getStatisticByMarkerTime = (state, marker) => {
  const tickets = getTicketList(state)
  if (tickets.length <= 0) return null

  const stats = {}

  for (let i = 0; i < tickets.length; i++) {
    const ticket = tickets[i]

    let chStatus = ticket.changelog.find((chObj, idx, changelog) => {
      const nextChObj = changelog[idx + 1]

      // ticket does not exist in marker time
      if (idx === 0 && marker < chObj.updatedAt) return false

      return chObj.updatedAt <= marker && nextChObj && marker < nextChObj.updatedAt
    })

    if (!chStatus) {
      const lastStatus = ticket.changelog.slice(-1).pop()
      if (lastStatus.updatedAt <= marker) {
        chStatus = lastStatus
      } else {
        // ticket does not exist in marker time
        continue
      }
    }

    if (stats[chStatus.id]) {
      stats[chStatus.id]++
    } else {
      stats[chStatus.id] = 1
    }
  }

  return stats
}
