import { DateTime } from 'luxon'

export const getFormat = ticks => {
  const [a, b] = ticks
  const from = DateTime.fromJSDate(a)
  const to = DateTime.fromJSDate(b)
  const diff = to.diff(from, ['years', 'months', 'weeks', 'days', 'hours'])

  if (diff.as('years') >= 1) {
    return 'yyyy'
  }
  if (diff.as('months') >= 3) {
    return 'MMM yyyy'
  }
  if (diff.as('months') >= 1) {
    return 'd MMM'
  }
  if (diff.as('weeks') >= 1) {
    // return 'd MMM'
    return 'HH:mm d MMM '
  }
  if (diff.as('days') >= 2) {
    // return 'd MMM'
    return 'HH:mm d MMM'
  }
  if (diff.as('hours') >= 6) {
    return 'HH:mm d MMM'
  }
  return 'HH:mm'
}
