const convict = require('convict')
const yaml = require('js-yaml')
const path = require('path')
const fs = require('fs')

convict.addParser({ extension: ['yaml'], parse: yaml.safeLoad })

const schema = yaml.safeLoad(fs.readFileSync(path.resolve(__dirname, 'schema.yaml')))

const config = convict({
  env: {
    doc: 'The application environment',
    format: ['development', 'production', 'demo'],
    default: 'development',
    env: 'NODE_ENV'
  },
  ...schema
})

try {
  config.loadFile(path.resolve(__dirname, 'env', `${config.get('env')}.yaml`))
} catch (e) {}

module.exports = config
