const ERROR_CODES = require('./codes')

const formatTrackerApiError = e => {
  switch ((e.cause && e.cause.code) || e.statusCode) {
    case 401:
      e.code = ERROR_CODES.AUTH_FAILED; break
    case 403:
      if (e.error && Array.isArray(e.error.errorMessages) && e.error.errorMessages.includes('Просроченная подпись.')) {
        e.code = ERROR_CODES.PAGINATON_CURSOR_FAILED
        break
      }
      e.code = ERROR_CODES.ACCESS_DENIED; break
    case 'ENOTFOUND':
    case 404:
      e.statusCode = 502
      e.code = ERROR_CODES.TRACKER_API_ROUTE_NOT_AVAILABLE; break
    case 400:
    case 422:
      e.code = ERROR_CODES.UNPROCESSABLE_QUERY; break
    case 429:
      e.statusCode = 502
      e.code = ERROR_CODES.TOO_MANY_REQUESTS_TO_TRACKER_API; break
    default:
      e.statusCode = 502
  }

  if (!e.code) {
    e.code = ERROR_CODES.UNEXPECTED_ERROR
  }

  return e.code
}

module.exports = {
  formatTrackerApiError
}
