const config = require('../config')

const { clientId, authorizationUri, redirectUri } = config.get('oauth')
const fullAuthorizationUri = `${authorizationUri}` +
  '?response_type=token' +
  `&client_id=${encodeURIComponent(clientId)}` +
  `&redirect_uri=${encodeURIComponent(redirectUri)}`

module.exports = () => async (req, res) => {
  res.redirect(fullAuthorizationUri)
}
