const { formatTrackerApiError } = require('../dependences/errorCodes')

module.exports = ({ statuses }) => async (req) => {
  try {
    const data = await statuses.load(req.token)
    return { error: null, data }
  } catch (error) {
    return { error: formatTrackerApiError(error), data: null }
  }
}
