module.exports = ({ taskList }) => async (req) => {
  const queryInput = (req.body && req.body.query) || ''
  const finalStatusInput = (req.body && req.body.finalStatus) || []

  // Injection prevent
  const query = queryInput.toString()
  const finalStatus = Array.isArray(finalStatusInput)
    ? finalStatusInput.map(status => status.toString())
    : []

  const [error, tasks] = await taskList.load(req.token, query, finalStatus)

  return { error, data: tasks }
}
