class CacheWarmup {
  constructor ({ interval, query, taskList }) {
    this.priority = 10
    this.interval = interval
    this.query = query
    this.tockensToFollow = {}
    this.taskList = taskList
    this.started = false
  }

  job () {
    Object.keys(this.tockensToFollow).forEach(token => {
      this.taskList.load(token, this.query, [], this.priority)
    })
  }

  followToken (token) {
    if (this.interval <= 0) { return }
    this.tockensToFollow[token] = true
    if (!this.started) { this._start() }
  }

  unfollowToken (token) {
    delete this.tockensToFollow[token]
  }

  _start () {
    this.started = true
    this.job()
    setInterval(this.job.bind(this), this.interval * 1000)
  }
}

module.exports = CacheWarmup
