'use strict'

class DoublyLinkedHashQueue {
  constructor () {
    this._hashmap = {}
    this._firstId = null
    this._lastId = null
    this.length = 0
  }

  push (id, el) {
    if (this._hashmap[id]) { this.remove(id) }

    if (this._lastId) {
      this._hashmap[this._lastId][2] = id
    } else {
      this._firstId = id
    }

    this._hashmap[id] = [el, this._lastId, null]
    this._lastId = id

    return ++this.length
  }

  unshift (id, el) {
    if (this._hashmap[id]) { this.remove(id) }

    if (this._firstId) {
      this._hashmap[this._firstId][1] = id
    } else {
      this._lastId = id
    }

    this._hashmap[id] = [el, null, this._firstId]
    this._firstId = id

    return ++this.length
  }

  pop () {
    const lastId = this._lastId
    if (!lastId) { return [lastId, undefined] }

    const [el] = this._hashmap[lastId]
    this.remove(lastId)
    return [lastId, el]
  }

  replace (id, el) {
    const item = this._hashmap[id]
    if (item) {
      item[0] = el
      return true
    } else {
      return false
    }
  }

  remove (id) {
    const item = this._hashmap[id]
    if (!item) { return -1 }
    const [, prevId, nextId] = item
    delete this._hashmap[id]

    const prevItem = this._hashmap[prevId]
    if (prevItem) {
      prevItem[2] = nextId
    } else {
      this._firstId = nextId
    }

    const nextItem = this._hashmap[nextId]
    if (nextItem) {
      nextItem[1] = prevId
    } else {
      this._lastId = prevId
    }

    return --this.length
  }

  get (id) {
    const item = this._hashmap[id]
    return item ? item[0] : undefined
  }
}

module.exports = DoublyLinkedHashQueue
