'use strict'

const DoublyLinkedHashQueue = require('./doublyLinkedHashQueue')

class PrioritizedHashQueue {
  constructor () {
    this._queues = {}
    this._priorities = {}
  }

  place (id, priority, el) {
    if (!this._queues[priority]) {
      this._queues[priority] = new DoublyLinkedHashQueue()
    }
    const queue = this._queues[priority]

    const existentPriority = this._priorities[id]

    if (!existentPriority) {
      this._priorities[id] = priority
      queue.unshift(id, el)
      return true
    }
    const prevQueue = this._queues[existentPriority]
    if (existentPriority > priority) {
      prevQueue.remove(id)
      this._priorities[id] = priority
      queue.unshift(id, el)
    } else {
      prevQueue.replace(id, el)
    }

    return false
  }

  pop () {
    for (const priority in this._queues) {
      const queue = this._queues[priority]
      const [id, el] = queue.pop()
      if (id) {
        delete this._priorities[id]
        return [id, priority, el]
      }
    }
    return []
  }
}

module.exports = PrioritizedHashQueue
