const { indexBy } = require('rambda')

const colors = [
  '#4bc5bc', '#fb8380', '#f6d157', '#cbd0ff', '#f3fac0',
  '#a6ddec', '#fdac8a', '#d1c3d1', '#b6e5c4', '#a88f8e'
]

class Statuses {
  constructor ({ trackerApi }) {
    this.trackerApi = trackerApi
  }

  async load (token) {
    const statuses = await this.trackerApi.getStatuses(token)
    const statusesHash = indexBy(status => status.id, statuses.map((status, index) => ({
      ...status,
      color: colors[index % colors.length]
    })))
    return statusesHash
  }
}

module.exports = Statuses
