const dateToTimestamp = require('../../utils/dateToTimestamp')
const filterWithoutEmpty = require('../../utils/filterWithoutEmpty')

const parseChangelog = changelog => {
  const statusField = changelog.fields.find(field => field.field.id === 'status')

  return statusField ? {
    updatedAt: dateToTimestamp(changelog.updatedAt),
    status: statusField.to.key,
    id: statusField.to.id
  } : null
}

module.exports = (changelog) => {
  return filterWithoutEmpty(changelog.map(parseChangelog))
}
