module.exports = (task, changelog) => {
  const lastStatus = changelog[changelog.length - 1]

  if (!task.previousStatus && !lastStatus) {
    return true
  } else if (!lastStatus) {
    return false
  } else {
    const isTimeDiffCorrect = Math.abs(task.statusStartTime - lastStatus.updatedAt) < 100
    const equalStatuses = task.statusId === lastStatus.id
    return isTimeDiffCorrect && equalStatuses
  }
}
