const getLastStatus = (task) => {
  return task.changelog[task.changelog.length - 1] || {
    id: 1,
    updatedAt: task.createdAt
  }
}

module.exports = (tasks, finalStatus) => tasks.sort((a, b) => {
  const [isFinishedA, isFinishedB] = [a, b].map(task =>
    finalStatus.includes(getLastStatus(task).id)
  )

  if (isFinishedA && isFinishedB) {
    const [closeTimeA, closeTimeB] = [a, b].map(task => getLastStatus(task).updatedAt)
    return closeTimeB - closeTimeA
  } else if (isFinishedA) {
    return 1
  } else if (isFinishedB) {
    return -1
  } else {
    const [startTimeA, startTimeB] = [a, b].map(task => task.createdAt)
    return startTimeA - startTimeB
  }
})
