const config = require('../../config')
const dateToTimestamp = require('../../utils/dateToTimestamp')

const TRACKER_URI = config.get('trackerUri')

const pickBaseTaskFields = (task) => ({
  id: task.id,
  key: task.key,
  summary: task.summary,
  priority: task.priority,
  tags: task.tags,
  assignee: task.assignee,
  createdBy: task.createdBy,
  createdAt: dateToTimestamp(task.createdAt),
  statusStartTime: dateToTimestamp(task.statusStartTime),
  previousStatus: task.previousStatus,

  statusId: task.status.id
})

const formatTaskForClient = (task, changelog) => ({
  id: task.id,
  key: task.key,

  title: task.summary,
  url: `${TRACKER_URI}${task.key}`,
  priority: task.priority.display,
  tags: task.tags,

  assignee: task.assignee,
  createdBy: task.createdBy,
  createdAt: task.createdAt,

  changelog
})

module.exports = {
  pickBaseTaskFields,
  formatTaskForClient
}
