/*
  Simple rfc5988 link header parser
*/

function parseLink (link) {
  const parts = link.split('; rel=')
  const uri = parts[0].slice(1, -1)
  const rel = parts[1].slice(1, -1)
  return [uri, rel]
}

module.exports = (data) => {
  if (typeof data !== 'string') { return {} }
  const links = data.split(', ')

  return links.reduce((acc, link) => {
    const [uri, rel] = parseLink(link)
    acc[rel] = uri
    return acc
  }, {})
}
