#!/usr/bin/python
# -*- coding: utf-8 -*-

"""
cat certs_external_certs_20200928.jsons | ./bin/dt-check-cert-content-ssl.py |tee certs_external_certs_20200928.jsons_ST_20201002

Одноразовый скрипт, чтобы видеть прогресс по раскатке сертификатов с пустым ST
(https://clubs.at.yandex-team.ru/security/14499)

Читает с stdin строчки вида:
["step.sandbox.yandex-team.ru,sandbox.yandex-team.ru", "CertumProductionCA", 469, "sandbox", "kossovich,r-vetrov,aripinen,yetty,artanis", "34718D734EB0DBD95C04B826AFAF507D"]

Важно, что это массив, и первым элементом -- строка с доменами через запятую.
Остальные элементы массива неважны.

Из доменов берет первый не-wildcard и обрабатывает его.
Если все домены со звездочками -- пишет ERR:NO_NOWILDCARD и пропускает эту строчку

Пишет про каждый домен какой ST нашелся в сертификате


На ppcdev не хватает библиотек, можно запускать локально.


sudo apt-get install python-ndg-httpsclient
"""

import ssl, socket
import json
import sys
import OpenSSL.crypto as crypto

import requests
from requests.packages.urllib3.contrib import pyopenssl as reqs
import inspect

def https_cert_info(hostname, port):
    conn = ssl.create_connection((hostname, port))
    context = ssl.SSLContext(ssl.PROTOCOL_SSLv23)
    sock = context.wrap_socket(conn, server_hostname=hostname)
    cert_bin = sock.getpeercert(True)
    x509 = crypto.load_certificate(crypto.FILETYPE_ASN1,cert_bin)
    return {'ST': (x509.get_subject().ST or ''), 'CN': (x509.get_subject().CN or '')}

if __name__ == '__main__':
    domains = []
    for line in sys.stdin:
        cert_data = json.loads(line)
        cert_domains = cert_data[0].split(",")
        no_wildcard_domain = next((x for x in cert_domains if x[0] != '*'), None)
        if no_wildcard_domain == None:
            print "ERR:NO_NOWILDCARD %s" % cert_domains
        domains.append( no_wildcard_domain )

    for d in domains:
        try:
            # таймаут в https_cert_info сопротивляется, быстрый воркэраунд: сделать get, если соединение проходит -- можно пробовать getpeercert
            r = requests.get('https://%s' % d, timeout=2)
            #pass
        except requests.exceptions.ConnectTimeout:
            print "ERR:TIMEOUT %s" % d
            continue
        except requests.exceptions.SSLError:
            print "ERR:SSL_ERROR %s" % d
            continue
        except requests.exceptions.ConnectionError:
            print "ERR:CONNECTION_ERROR %s" % d
        except requests.exceptions.ReadTimeout:
            pass
        except requests.exceptions.TooManyRedirects:
            pass

        try:
            res = https_cert_info(d, 443)
        except:
            print "ERR: %s" % d
            continue
        print "%s CN='%s' ST='%s'" % (d.encode('utf-8'), res['CN'].encode('utf-8'), res['ST'].encode('utf-8'))

