#!/usr/bin/python
# -*- coding: utf8 -*-

import os
import json

from juggler_sdk import JugglerApi, Check
import juggler_sdk

def jdumps(jdict):
    #return str(jdict)
    def serialize(obj):
        try:
            s = obj.__dict__
        except:
            s = str(obj)
        return s
    return json.dumps(jdict, sort_keys=True, ensure_ascii=False, default=serialize)


def my_upsert(api, check):
    res = api.upsert_check(check)
    changes_type = 'unchanged'
    details = ''
    if res.changed:
        changes_type = ''
        if isinstance(res.diff, juggler_sdk.check_sync.FullCheckDifference):
            changes_type = 'inserted'
        else:
            changes_type = 'updated'
        details = "check %s: %s / %s:%s, diff: %s" % (changes_type, check.namespace, check.host, check.service, jdumps(res.diff))
    else:
        details = "check %s: %s / %s:%s" % (changes_type, check.namespace, check.host, check.service)
    return { "changes_type": changes_type, "details": details,}


def make_check_obj(params):
    '''
    получает дикт с существенными параметрами для проверки:
    host
    service
    warn_expire
    crit_expire
    type (https, https_cert и т.д.)
    child_hosts

    возвращает полный дикт, из которого можно делать Check
    '''
    check_params = {
            "namespace": "direct.prod",
            "host": "adv.prod_ssl",
            "service": "",
            "refresh_time": 90,
            "ttl": 900,
            "aggregator": "logic_or",
            "active": "https_cert",
            "active_kwargs":
                {
                    "validate_hostname": "true",
                    "warn_expire": 60,
                    "crit_expire": 30,
                },
            "tags": [ 'adv_ssl' ],
            "children": [],
            }
    for k in ['host', 'service',]:
        if k in params:
            check_params[k] = params[k]
    for k in ['warn_expire', 'crit_expire']:
        if k in params:
            check_params['active_kwargs'][k] = params[k]
    if 'type' in params:
        check_params["active"] = params['type']
    if 'tags' in params:
        check_params["tags"] += params['tags']
    for h in params['child_hosts']:
        check_params['children'].append(juggler_sdk.Child(
            host=h,
            service="adv_ssl_"+check_params['active'],
            group_type='HOST',
            ))
    #check = Check(**check_params)
    return check_params


def make_check(api, domains_file, check_params):
    with open(domains_file) as f:
        domains = f.read().splitlines()
    check_params['child_hosts'] = domains
    ch = make_check_obj( check_params )

    result = my_upsert(api, Check(**ch))
    print "\nresult: %s\n\n" % ( result )



def run():

    JUGGLER_OAUTH_TOKEN = os.environ.get('JUGGLER_OAUTH_TOKEN', '')
    if not JUGGLER_OAUTH_TOKEN:
        with open("/etc/direct-tokens/juggler_api") as fh:
            JUGGLER_OAUTH_TOKEN = fh.read().strip()

    with JugglerApi("http://juggler-api.search.yandex.net", oauth_token=JUGGLER_OAUTH_TOKEN, mark="mark-dt-create-ssl-checks.py", dry_run=False) as api:

        make_check(api, 'etc/direct_qloud_ext_domains.txt', {
            'service': 'direct_qloud-ext_domains',
            'warn_expire': 10,
            'crit_expire': 7,
            'tags': ['adv_ssl_directadmin_tv'],
            })

        make_check(api, 'etc/adv_domains.txt', {
            'service': 'adv_domains_5_3_d',
            'warn_expire': 5,
            'crit_expire': 3,
            'tags':['adv_ssl_directadmin_tv'],
            })

        make_check(api, 'etc/adv_domains.txt', {
            'service': 'adv_domains_30_7_d',
            'warn_expire': 30,
            'crit_expire': 7,
            })
        make_check(api, 'etc/adv_domains_problems.txt', {
            'service': 'adv_domains_problems',
            })

if __name__ == '__main__':
    run()
