#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import sys
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
import os
import argparse
import requests
import json
import tempfile
import shutil
import subprocess


ABC_API_URL = 'https://abc-back.yandex-team.ru/api/v4/'
ABC_API_URL_RESOURCES = 'https://abc-back.yandex-team.ru/api/v4/resources/consumers/?service=%s&with_childs=1&supplier=770&type=59&page_size=1000'
ABC_API_URL_SERVICES = 'https://abc-back.yandex-team.ru/api/v4/services/?state=develop&page_size=1000'
SVN_PATH = ''
OAUTH_HEADER = {}
CERT_RESP = {}

def get_abc_services():
    headers = OAUTH_HEADER

    url = ABC_API_URL_SERVICES

    services = []
    next_url = url
    while( next_url is not None ):
        resp = requests.get(next_url, headers=headers, timeout=5)
        resp.raise_for_status()
        resp = resp.json()

        for item in resp['results']:
            services.append({'id': item['id'], 'slug': item['slug'],})

        next_url = resp.get('next')

    return services


def cert_resp_for_abc_service_api(service):
    headers = OAUTH_HEADER
    result = []
    resp = requests.get(
        "%sservices/members/" % ABC_API_URL,
        params={'fields': 'person.login', 'page_size': '1000', 'service__slug': service, 'role__code': 'certs-resp'},
        headers=headers,
    )
    resp.raise_for_status()
    data = resp.json()
    result = [el['person']['login'] for el in data['results']]
    return result

def cert_resp_for_abc_service(service):
    if service not in CERT_RESP:
        CERT_RESP[service] = cert_resp_for_abc_service_api(service)
    return CERT_RESP[service]


def get_abc_resources_for_service(service, alias):
    headers = OAUTH_HEADER

    url = ABC_API_URL_RESOURCES % service

    resources = []
    next_url = url
    while( next_url is not None ):
        resp = requests.get(next_url, headers=headers, timeout=15)
        resp.raise_for_status()
        resp = resp.json()

        for item in resp['results']:
            if item['state'] != u'granted':
                continue
            abc_res = item['resource']

            res = { 'service': service, 'external_id': abc_res['external_id'], 'service_alias': alias }
            res['attrs'] = {}
            for attr in abc_res['attributes']:
                res['attrs'][attr['name']] = attr['value']

            resources.append(res)

        next_url = resp.get('next')

    return resources


def print_resources(r_list):
    for r in r_list:
        certs_resp = ",".join(cert_resp_for_abc_service(r['service_alias']))
        if not 'hosts' in r['attrs']:
            continue
        hosts = ",".join(r['attrs']['hosts'])
        print(json.dumps([ hosts, r['attrs']['ca_name'], r['service'], r['service_alias'], certs_resp, r['external_id'] ]))
        continue
        for h in r['attrs']['hosts']:
            print(json.dumps([ h, r['attrs']['ca_name'], r['service'], r['service_alias'], certs_resp, r['external_id'] ]))
            #print "%s %s %s %s %s" % ( h, r['attrs']['ca_name'], r['service'], r['service_alias'].encode('utf-8'),  r['external_id'] )
    return


def parse_args():
    global SVN_PATH

    parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, description=__doc__)
    parser.add_argument('-t', '--token', default="~/.abc-auth-token", help='путь до oauth токена')
    parser.add_argument(
        '--do', default=False, action='store_true',
        help='привезти изменения, иначе просто выводится информация'
    )
    args = parser.parse_args()

    return args


def main():
    global OAUTH_HEADER
    args = parse_args()

    try:
        with open(os.path.expanduser(args.token), 'r') as fh:
            OAUTH_HEADER = {'Authorization': 'OAuth ' + fh.read().strip()}
    except:
        sys.exit("can't get oauth token")

    services = get_abc_services()
    i = 0
    for s in services:
        i += 1
        if i> 5:
            #break
            pass
        resources = get_abc_resources_for_service( service=s['id'], alias=s['slug'] )
        print_resources(resources)


if __name__ == '__main__':
    main()

