#!/usr/bin/python3

import os
import re
import shlex
import subprocess
import sys

JCTL_PATH = os.environ['HOME'] + '/arc/arcadia/juggler/jctl/bin/jctl'

CHILDREN = {}

def print_with_children(host, service, depth):
    if depth > 10:
        raise Exception('something gone wrong, recursion too deep')
    global CHILDREN
    hs = host + ':' + service
    print('    ' * depth + host + ' ' + service)
    children = None
    if hs in CHILDREN:
        children = CHILDREN[hs]
    else:
        if (
                host.startswith('DEPLOY%')
                or host.startswith('CGROUP%')
                or re.search(r'\b(ppc_?[0-9]+|ppcdata[0-9]+|ppcdict|ppcmonitor|shard_[0-9]+|param_\w+)\b', service)
                or re.search(r'ppcdata[0-9]+$', service)
                or host.startswith('direct.prod_ppcdata.db_mdb.')
                or service.startswith('trending-errors')
                or host.endswith('access-log')
                or host == 'direct.prod_javaperl'
                or host.startswith('direct.prod_slb')
                or re.search(r'\bppc_[0-9]+\b', host)
           ):
            CHILDREN[hs] = []
            return
        out_lines = subprocess.check_output([JCTL_PATH, 'dump', 'check', '-host', host, '-service', service]).decode('utf-8').rstrip().split('\n')
        add_cmdlines = [line for line in out_lines if line.find('add check') > -1]
        if not add_cmdlines:
            CHILDREN[hs] = []
            return
        add_cmdline = add_cmdlines[0]
        add_cmd = shlex.split(add_cmdline)
        do_append_to_children = False
        children = []
        for arg in add_cmd:
            if not do_append_to_children and arg == '-children':
                do_append_to_children = True
            elif do_append_to_children and arg.startswith('-'):
                break
            elif do_append_to_children and arg != hs:   # если arg == hs, то агрегат над сырыми событиями с такими же host и service
                children.append(arg)
        CHILDREN[hs] = children
    for child in children:
        child_host, child_service = child.split(':')
        print_with_children(child_host, child_service, depth + 1)

for line in sys.stdin.readlines():
    host, service = line.split(' ')[0:2]
    print_with_children(host, service, 0)
