from infra.awacs.proto import api_pb2, api_stub
from nanny_rpc_client import RequestsRpcClient
import os


# дока: https://wiki.yandex-team.ru/awacs/api/
def main():
    f = open(os.path.join(os.environ['HOME'], '.awacs_token'), 'r')
    token=f.read().replace('\n', '')
    url = 'https://awacs.yandex-team.ru/api/'
    client = RequestsRpcClient(url, oauth_token=token)
    upstreams_stub = api_stub.UpstreamServiceStub(client)
    req_pb = api_pb2.ListUpstreamsRequest(namespace_id="direct.yandex.ru", limit=10)
    resp_pb = upstreams_stub.list_upstreams(req_pb, limit=10)
    for upstream_pb in resp_pb.upstreams:
        print('### ' + upstream_pb.meta.id)
        print(upstream_pb.spec.yandex_balancer.yaml)


if __name__ == '__main__':
    main()
