# Принимаем дефолтные ответы на любые вопросы при установке и обновлении зависимостей
export DEBIAN_FRONTEND=noninteractive;

set -ex;

##### -------------------------------------------------------------------------------------------------- #####
#####                               Установка пакетов для сборки yandex-direct                           #####
##### -------------------------------------------------------------------------------------------------- #####

echo "deb http://common.dist.yandex.ru/common/ stable/all/" >> /etc/apt/sources.list
echo "deb http://common.dist.yandex.ru/common/ stable/amd64/" >> /etc/apt/sources.list

echo "deb http://direct-common.dist.yandex.ru/direct-common/ stable/all/" >> /etc/apt/sources.list
echo "deb http://direct-common.dist.yandex.ru/direct-common/ stable/amd64/" >> /etc/apt/sources.list

echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ stable/all/" >> /etc/apt/sources.list
echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ stable/amd64/" >> /etc/apt/sources.list
echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ unstable/all/" >> /etc/apt/sources.list
echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ unstable/amd64/" >> /etc/apt/sources.list

echo "deb http://search-kernel.dist.yandex.ru/search-kernel stable/all/" >> /etc/apt/sources.list
echo "deb http://search-kernel.dist.yandex.ru/search-kernel stable/amd64/" >> /etc/apt/sources.list

echo "deb http://system.dist.yandex.ru/system/ trusty/all/" >> /etc/apt/sources.list
echo "deb http://system.dist.yandex.ru/system/ trusty/amd64/" >> /etc/apt/sources.list

echo "deb http://yandex-trusty.dist.yandex.ru/yandex-trusty/ stable/all/" >> /etc/apt/sources.list
echo "deb http://yandex-trusty.dist.yandex.ru/yandex-trusty/ stable/amd64/" >> /etc/apt/sources.list

# см. https://a.yandex-team.ru/arcadia/direct/perl/packages/yandex-direct/debian/control?rev=11d3b07e7ce7c7f7cb1f329753e01656fc7bf320#L5-24
apt-get update --fix-missing && apt-get install -y --no-remove \
    debhelper \
    yandex-ycssjs \
    catdoc \
    gettext \
    yandex-svn-release \
    yandex-dh-environment \
    yandex-du-bem-builder-perl \
    yandex-du-scripts-metadata \
    yandex-du-metadata-perl \
    yandex-du-shell-perl \
    liblocale-po-perl \
    libappconfig-perl \
    libtemplate-plugin-yaml-perl \
    texlive-latex-extra \
    texlive-lang-cyrillic \
    liblatex-driver-perl \
    scalable-cyrfonts-tex \
    texlive-fonts-recommended \
    yandex-du-metricslog-perl \
    yandex-du-beta-service-perl \
    nodejs-0.10 \
    yandex-du-translation=2.26-1 \
    rsync \
    yandex-jdk8 \
    cpanminus \
    dupload;

useradd -m zookeeper;

# см. https://a.yandex-team.ru/svn/trunk/arcadia/direct/perl/etc/quasi-make/Beta.pm?rev=r9530159#L49
cpanm --no-lwp --curl File::chdir;

apt-get autoremove --assume-yes;

apt-get clean;
rm -rf /var/lib/apt/lists/*;
