##### -------------------------------------------------------------------------------------------------- #####
#####                                     Установка утилитарных пакетов                                  #####
##### -------------------------------------------------------------------------------------------------- #####

# Принимаем дефолтные ответы на любые вопросы при установке и обновлении зависимостей
export DEBIAN_FRONTEND=noninteractive;

set -ex;

apt-get update;
apt-get install \
	--no-install-recommends --no-install-suggests --assume-yes \
	apt-transport-https \
	ca-certificates \
	curl \
	gnupg;

# Ключ для аутентификации пакетов из репозитория Яндекса
curl http://dist.yandex.ru/yandexrepo/GPG-KEY-yandex | apt-key add -;

# SSL сертификаты Яндекса
curl https://crls.yandex.net/allCAs.pem > /etc/ssl/certs/allCAs.pem;
curl https://crls.yandex.net/allCAs.pem >> /etc/ssl/certs/ca-certificates.crt;

apt-get install \
	--no-install-recommends --no-install-suggests --assume-yes \
	locales \
	tzdata \
	yandex-internal-root-ca;

apt-get install \
	--no-install-recommends --no-install-suggests --assume-yes \
	build-essential \
  coreutils;

apt-get install \
	--no-install-recommends --no-install-suggests --assume-yes \
	git \
	host \
	htop \
	iproute2 \
	iputils-ping \
	jq \
	less \
	man \
	nano \
	netcat-openbsd \
	sed \
	strace \
  subversion \
	supervisor \
	tcpdump \
	vim;

echo 'Europe/Moscow' > /etc/timezone;
[ -s /usr/share/zoneinfo/Europe/Moscow ] && ln -fs /usr/share/zoneinfo/Europe/Moscow /etc/localtime;
if [ -L /usr/share/zoneinfo/UTC ] && [ -f /usr/share/zoneinfo/Etc/UTC ]; then ln -fs /usr/share/zoneinfo/Etc/UTC /usr/share/zoneinfo/UTC; fi;
dpkg-reconfigure --frontend noninteractive tzdata;

locale-gen en_US.UTF-8;

export LANG=en_US.UTF-8;
cat >> /etc/profile.d/LANG.sh << "EOF"
export LANG=en_US.UTF-8
EOF

cp /root/.bashrc /.bashrc;

##### -------------------------------------------------------------------------------------------------- #####
#####                               Установка пакетов для сборки data3                                   #####
##### -------------------------------------------------------------------------------------------------- #####

export NODEJS_MAJOR="16";
export NODEJS_VERSION="16.13.2";

# Устанавливаем nodejs который приезжает из sandbox-ресурса
cd /tmp/nodejs;
tar -xzf nodejs.tgz;

cp -r nodejs/{bin,include,lib,share} /usr/;
export PATH=/usr/nodejs/bin:$PATH;

npm --global config set registry=https://npm.yandex-team.ru/;

# Необходимо чтобы иметь возможность собирать нативные npm модули 
npm --global config set user root;

export npm_config_cache=$(mktemp -d);

rm -rf $npm_config_cache;

# Необходимо чтобы иметь возможность собирать нативные npm модули 
chmod 1777 /tmp;

cat >> /etc/profile.d/NODEJS.sh << "EOF"
export NODE_EXTRA_CA_CERTS=/etc/ssl/certs/YandexInternalRootCA.pem
export NODE_ICU_DATA=/usr/lib/node_modules/full-icu
export NODE_PATH=/usr/lib/node_modules/
EOF

export YANDEX_LOGS_DIR=/var/log/yandex;
mkdir -p $YANDEX_LOGS_DIR;
chmod 777 $YANDEX_LOGS_DIR;

##### -------------------------------------------------------------------------------------------------- #####
#####                               Установка пакетов для запуска yandex-direct                          #####
##### -------------------------------------------------------------------------------------------------- #####

npm install --global zlo@0.5.14

echo "deb http://common.dist.yandex.ru/common/ stable/all/" >> /etc/apt/sources.list
echo "deb http://common.dist.yandex.ru/common/ stable/amd64/" >> /etc/apt/sources.list
echo "deb http://direct-common.dist.yandex.ru/direct-common/ stable/all/" >> /etc/apt/sources.list
echo "deb http://direct-common.dist.yandex.ru/direct-common/ stable/amd64/" >> /etc/apt/sources.list
echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ stable/all/" >> /etc/apt/sources.list
echo "deb http://direct-trusty.dist.yandex.ru/direct-trusty/ stable/amd64/" >> /etc/apt/sources.list
echo "deb http://search-kernel.dist.yandex.ru/search-kernel stable/all/" >> /etc/apt/sources.list
echo "deb http://search-kernel.dist.yandex.ru/search-kernel stable/amd64/" >> /etc/apt/sources.list
echo "deb http://system.dist.yandex.ru/system/ trusty/all/" >> /etc/apt/sources.list
echo "deb http://system.dist.yandex.ru/system/ trusty/amd64/" >> /etc/apt/sources.list
echo "deb http://yandex-trusty.dist.yandex.ru/yandex-trusty/ stable/all/" >> /etc/apt/sources.list
echo "deb http://yandex-trusty.dist.yandex.ru/yandex-trusty/ stable/amd64/" >> /etc/apt/sources.list

# При сборке porto слоя в sandbox нет sky, а libgeobase5-perl пытается скачать свои данные при его помощи
# Чтобы не пытаться скачивать данные геобазы при сборке слоя создаём файл /etc/yandex/p2p_do_nothing
# см. https://wiki.yandex-team.ru/geotargeting/libgeobase/faq/#geobazaip2p-distribucija
mkdir -p /etc/yandex;
touch /etc/yandex/p2p_do_nothing;

# Пакет monrun в post intall script-е генерирует исключение RuntimeError("Cannot determine my FQDN")
# см. https://a.yandex-team.ru/arcadia/juggler/monrun/gethostname.py?rev=r9606247#L24
# Так что мы изменям /etc/hosts таким образом чтобы monrun мог выполнить post install 
echo "127.0.1.1 $(hostname).fix.monrun $(hostname)" >> /etc/hosts

apt-get update --fix-missing && apt-get install -y --no-remove \
    monrun=1.3.5 \
    juggler-client=2.3.12060547;

# см. https://a.yandex-team.ru/arcadia/direct/perl/packages/yandex-direct/debian/control?rev=11d3b07e7ce7c7f7cb1f329753e01656fc7bf320#L29-266
apt-get update --fix-missing && apt-get install -y --no-remove \
    yandex-direct-send-logs-to-logbroker \
    libyandex-xsutils-perl \
    yandex-du-advmon-perl \
    yandex-du-avatars \
    yandex-du-balance-perl \
    yandex-du-blackbox-perl \
    yandex-du-bmlightadvq-perl \
    yandex-du-bmwordstat-perl \
    yandex-du-bsinfo-perl \
    yandex-du-bstools-perl \
    yandex-du-captcha-perl \
    yandex-du-catalogia-perl \
    yandex-du-cbb-perl \
    yandex-du-cgi-utf8-perl \
    yandex-du-clickhouse-perl \
    yandex-du-compress-perl \
    yandex-du-csv-perl \
    yandex-du-data-utils-perl \
    yandex-du-datetime-perl \
    yandex-du-dbtools-perl \
    yandex-du-direct-modern-perl \
    yandex-du-execute-js-perl \
    yandex-du-golem-perl \
    yandex-du-highlight-words-perl \
    yandex-du-hostname-perl \
    yandex-du-http-perl \
    yandex-du-i18n-perl \
    yandex-du-idn-perl \
    yandex-du-interpolate-perl \
    yandex-du-ketama-perl \
    yandex-du-live-file-perl \
    yandex-du-log-perl \
    yandex-du-lwp-useragent-zora-perl \
    yandex-du-mds-perl \
    yandex-du-memcached-perl \
    yandex-du-ml-clustering-perl \
    yandex-du-mygoodwords-perl \
    yandex-du-stopwords-perl \
    yandex-du-myinc-perl \
    yandex-du-mirrortools-hostings-perl \
    yandex-du-oauth-perl \
    yandex-du-parallel-perl \
    yandex-du-passport-perl \
    yandex-du-perlio-perl \
    yandex-du-plack-perl \
    yandex-du-phrasetools-perl \
    yandex-du-procinfo-perl \
    yandex-du-profile-perl \
    yandex-du-trace-perl \
    yandex-du-queryrec-perl\
    libyxqueryrec-perl \
    yandex-du-reports-xls-perl \
    yandex-du-retry-perl \
    yandex-du-runtime-perl \
    yandex-du-sendmail-perl \
    yandex-du-shell-perl \
    yandex-du-sleep-under-load \
    yandex-du-speller-perl \
    yandex-du-staff-perl \
    yandex-du-svn-perl \
    yandex-du-tanker-perl \
    yandex-du-tcpmultiplexor-perl \
    yandex-du-template-perl \
    yandex-du-test-utf8-builder-perl \
    yandex-du-tvm2-perl \
    yandex-du-validate-perl \
    yandex-du-xls-utf8-perl \
    yandex-du-xmlrpc-serializer-perl \
    yandex-du-yacotools-perl \
    yandex-du-ymaps-perl \
    yandex-du-ya-money-perl \
    yandex-du-url-perl \
    yandex-du-xiva-perl \
    yandex-du-yt-perl \
    yandex-du-check-mobile-redirect \
    libjson-pointer-perl \
    yandex-du-redis-ratelimit-perl \
    liblatex-driver-perl \
    scalable-cyrfonts-tex \
    texlive-fonts-recommended \
    texlive-lang-cyrillic \
    texlive-latex-extra \
    texlive-latex-recommended \
    yandex-du-geobase-pm-perl \
    yandex-direct-dpkg-monitor-configs \
    yandex-direct-user\
    yandex-du-dbconfig-monitor \
    yandex-du-downtime-monitor \
    yandex-du-log-arc \
    yandex-du-translation \
    yandex-du-resource-yacatalog\
    yandex-direct-zk-delivery-configs \
    libapache2-mod-perl2 \
    apache2 \
    libapr1 \
    libplack-perl \
    libhash-multivalue-perl \
    liblib-abs-perl \
    libpath-tiny-perl \
    libpathtools-perl \
    libgetopt-long-descriptive-perl \
    libpod-simple-perl \
    libclass-accessor-perl \
    libclass-accessor-lite-perl \
    libexporter-tiny-perl \
    libio-socket-timeout-perl \
    libperlio-via-timeout-perl \
    libhash-merge-simple-perl \
    liblist-moreutils-perl \
    liblist-allutils-perl \
    liblist-utilsby-perl \
    libperlio-util-perl\
    libparallel-forkmanager-perl \
    libfilesys-df-perl\
    libtext-clemmer-perl \
    libgeobase5-perl \
    p2p-distribution-geobase4-config \
    libdbi-perl\
    libdbd-mysql-perl \
    libberkeleydb-perl \
    libnet-libidn-perl \
    libwww-perl \
    libnet-http-perl \
    liburi-escape-xs-perl \
    libpoe-perl \
    libpoe-component-client-http-perl \
    libwww-mechanize-perl \
    libhttp-body-perl \
    libparams-validate-perl \
    libdevel-stacktrace-perl \
    libanyevent-perl \
    libanyevent-fork-perl \
    libanyevent-fork-rpc-perl \
    libregexp-ipv6-perl \
    libnet-ipv6addr-perl \
    libev-perl \
    libsoap-lite-055-perl \
    libsoap-transport-http-plack-perl \
    yandex-soap-transport-http-plack \
    librouter-simple-perl \
    libjson-rpc-perl \
    libjson-rpc-simple-perl \
    libjson-rpc2-perl \
    libjsv-perl \
    liblwp-protocol-https-perl \
    libmailtools-perl \
    libmath-round-perl \
    libmime-lite-perl \
    libmime-tools-perl \
    libmime-types-perl \
    libemail-date-format-perl \
    libemail-valid-perl \
    libnet-ip-perl \
    libnet-patricia-perl \
    libnet-ldap-perl \
    libtest-harness-perl \
    libtest-deep-perl \
    libtest-mock-lwp-perl \
    libtest-mocktime-perl \
    libtest-failwarnings-perl \
    libtext-diff-perl \
    libtest-differences-perl \
    libgd-gd2-noxpm-perl \
    libimage-resize-perl \
    libcrypt-cbc-perl \
    libcrypt-rijndael-perl \
    libcarp-always-perl \
    perlmagick \
    libmagickcore5 \
    libimage-exiftool-perl \
    libcairo-perl \
    flasm \
    swftools \
    swfmill \
    multitail \
    time\
    libspreadsheet-writeexcel-perl \
    libspreadsheet-parseexcel-perl \
    libexcel-reader-xlsx-perl \
    libtemplate-perl \
    libcgi-fasttemplate-perl \
    libcompress-raw-zlib-perl \
    libio-compress-perl \
    libarchive-zip-perl \
    libdate-calc-perl \
    libdatetime-perl \
    libdatetime-format-mysql-perl \
    libdatetime-timezone-perl \
    libdigest-adler32-perl \
    libdigest-sha1-perl \
    libdigest-crc-perl \
    libdigest-murmurhash-perl \
    openssl \
    libcrypt-ssleay-perl \
    libnet-ssleay-perl \
    libio-stringy-perl \
    libfile-slurp-perl \
    libfile-touch-perl \
    libtext-csv-perl \
    libxml-libxml-perl \
    libxml-simple-perl \
    libxml-rss-perl \
    libyaml-perl \
    libyaml-syck-perl \
    libdata-printer-perl \
    libdata-messagepack-perl \
    libjavascript-v8-perl \
    libclone-perl \
    libguard-perl \
    libdatetime-format-iso8601-perl \
    libcache-memcached-fast-perl \
    libredis-cluster-perl \
    libredis-script-perl \
    libcache-cache-perl\
    libintl-xs-perl \
    language-pack-ru-base \
    language-pack-uk-base \
    language-pack-en-base \
    language-pack-tr-base \
    libjson-perl \
    libdigest-sha2-perl \
    libpdf-api2-perl \
    yandex-du-libproject-specific-perl \
    libstring-numeric-perl \
    libstring-numeric-xs-perl \
    yandex-lang-detect-perl \
    yandex-lang-detect-data \
    libcookiemy-perl\
    libmouse-perl \
    uatraits-perl \
    uatraits-data \
    libdata-leaf-walker-perl \
    yandex-lockf \
    python-central \
    libsys-hostname-fqdn-perl \
    libsys-sigaction-perl \
    switchman \
    util-linux \
    libreadonly-perl \
    libdata-uuid-perl \
    libexception-class-perl \
    libtry-tiny-perl \
    libnet-inet6glue-perl \
    liblog-any-perl \
    yandex-du-log-any-perl \
    libnet-surveymonkey-perl \
    libscalar-list-utils-41-perl \
    yandex-du-debsums-check \
    libyandex-startrek-client-easy-perl \
    libdigest-hmac-perl\
    libplack-middleware-headers-perl \
    libxml-compile-wsdl11-perl \
    libcapture-tiny-perl \
    yandex-du-juggler-perl \
    yandex-du-access-check-conf-common \
    yandex-du-graphite-conf;


apt-get autoremove --assume-yes;

apt-get clean;
rm -rf /var/lib/apt/lists/*;
