#!/usr/bin/python3

import copy
import json
import os
import subprocess
import shlex
import sys

mysql_config_5_7 = {
    "binlogRowImage": "NOBLOB",
	"characterSetServer" : "utf8",
	"collationServer" : "utf8_general_ci",
    "innodbBufferPoolSize": 105226698752,
    "innodbFlushLogAtTrxCommit": 1,
	"innodbLogBufferSize" : 268435456,
	"innodbLogFileSize" : 1073741824,
	"longQueryTime" : 10,
	"maxConnections" : 8000,
	"mdbPreserveBinlogBytes" : 549755813888,   # 25% от 2Tb
    "rangeOptimizerMaxMemSize": 134217728,
	"sqlMode" : [ "NO_UNSIGNED_SUBTRACTION", ],
	"transactionIsolation" : "READ_COMMITTED",
}
config = {
    "access": {},
    "backupWindowStart": { "hours": 22, },
	"mysqlConfig_5_7": mysql_config_5_7,
    "resources": {
        "resourcePresetId": "m1.xlarge",
        "diskSize": str(2*1024*1024*1024*1024),
        "diskTypeId": "local-ssd",
    },
    "version": "5.7",
}
param = {
    "configSpec": config,
   	"deletionProtection": True,
}

cluster_name = sys.argv[1]

user_specs = []
for item in [
    ('ppc',         'sec-01crx9etgqpm3hd8842ckdwn4t', 'mysql_ppc',          ['ppc', 'heartbeat'], ['SELECT', 'INSERT', 'UPDATE', 'DELETE', 'CREATE', 'DROP', 'ALTER', 'LOCK_TABLES'],   ['REPLICATION_CLIENT', 'REPLICATION_SLAVE', 'PROCESS']),
    ('direct-ro',   'sec-01crge0p4cryad9styvxqzqckm', 'mysql_direct-ro',    ['ppc', 'heartbeat'], ['SELECT'],                                                                           ['REPLICATION_CLIENT', 'REPLICATION_SLAVE', 'PROCESS']),
    ('direct-sql',  'sec-01cs2fk1nb5a09nps6ypma3r9e', 'mysql_direct-sql',   ['ppc', 'heartbeat'], ['ALL_PRIVILEGES'],                                                                   ['REPLICATION_CLIENT', 'REPLICATION_SLAVE', 'PROCESS']),
]:
    name, yav_id, yav_key, dbs, roles, global_perms = item
    yav_out = subprocess.check_output(['ya', 'vault', 'get', 'secret', yav_id, '--json'])
    latest_version = json.loads(yav_out.decode('utf-8'))['secret_versions'][0]['version']
    yav_out = subprocess.check_output(['ya', 'vault', 'get', 'version', latest_version, '--json'])
    password = json.loads(yav_out.decode('utf-8'))['value'][yav_key]
    user_specs.append({
        'name': name,
        'password': password,
        'permissions': [ {'databaseName': db, 'roles': roles} for db in dbs ],
        'globalPermissions': global_perms,
    })

def generate_curl_cmd(token, data):
    jsondata = json.dumps(data)
    # https://docs.yandex-team.ru/cloud/managed-mysql/api-ref/Cluster/create
    # curl а не http-запрос через библиотеку для простоты отладки
    return [
        'curl', '-s', '-f',
        '-H', 'Content-Type: application/json; charset=utf-8',
        '-H', 'Authorization: Bearer ' + token,
        'https://gw.db.yandex-team.ru/managed-mysql/v1/clusters',
        '-d', jsondata
    ]

token = os.environ.get('IAM_TOKEN', None) or subprocess.check_output(['yc', 'iam', 'create-token']).decode('utf-8').rstrip()
data = {
    'folderId': 'fooa07bcrr7souccreru',
    'name': cluster_name,
    'environment': 'PRODUCTION',
    'configSpec': config,
    'databaseSpecs': [
        {'name': 'ppc'},
        {'name': 'heartbeat'},
    ],
    'userSpecs': user_specs,
    'hostSpecs': [ { 'zoneId': dc, 'assignPublicIp': False } for dc in ['sas', 'vla', 'man', 'iva'] ],
    'deletionProtection': True,
}
sanitized_data = copy.deepcopy(data)
for i in range(0, len(sanitized_data['userSpecs'])):
    sanitized_data['userSpecs'][i]['password'] = '<redacted_password>'
cmd = generate_curl_cmd(token, data)
sanitized_cmd = generate_curl_cmd('<redacted_token>', sanitized_data)
cmd_str = shlex.join(sanitized_cmd)
print(cmd_str)
try:
    out_json = subprocess.check_output(cmd).decode('utf-8')
    print(out_json)
except subprocess.CalledProcessError as e:
    cmd_str = shlex.join(sanitized_cmd)
    sys.exit("command failed:\n\n  " + cmd_str)
