# -*- coding: utf-8 -*-

import yt.wrapper as yt
import argparse
import subprocess
import os


# Скрипт считает количество использований фичей в коде и записывает их в переданную YT табличку
# Пример запуска:
# python3 count_features.py --root_path "direct" --proxy "hahn.yt.yandex.net"
# --input_table "//home/direct/mysql-sync/current/ppcdict/straight/features"
# --output_table "//home/direct/test/features/features_using_in_code"
# Берём фичи из таблички --input_table из столбца feature_text_id, считаем использования,
# путь к которым начинается с --root_path и записываем в --output_table


def recursive_grep(root, substring):
    bash_command = "ya tool cs -i " + substring + " -f ^" + root + ".*"
    process = subprocess.Popen(bash_command.split(), stdout=subprocess.PIPE)
    output, error = process.communicate()
    return dict(map(lambda x: split_result(bytes.decode(x)), output.splitlines()))


def split_result(result):
    splitted = result.split(':')
    return splitted[0], ({'line_number': splitted[1], 'substr': splitted[2]})


def count_features(root, features):
    feature_stat = []
    for feature in features:
        stat = recursive_grep(root, feature)
        feature_stat.append({'feature': feature, 'lines': stat, "total": len(stat)})
    return feature_stat


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--root_path', type=str,
                        help='root path')
    parser.add_argument('--proxy', default='hahn.yt.yandex.net')
    parser.add_argument('--input_table', default='//home/direct/mysql-sync/current/ppcdict/straight/features')
    parser.add_argument('--output_table', default='//home/direct/test/features/features_using_in_code')
    return parser.parse_args()


def read_feature_list(input_table):
    result = []
    for row in client.read_table(input_table):
        result.append(row['feature_text_id'])
    return result


def write_feature_stat(output_table):
    client.write_table(output_table, feature_stat_by_name)


args = parse_args()

client = yt.YtClient(args.proxy, token=os.getenv('YT_TOKEN'))

feature_list = read_feature_list(args.input_table)

feature_stat_by_name = count_features(args.root_path, feature_list)

write_feature_stat(args.output_table)
