#!/usr/bin/env python3

import argparse
import difflib
import requests
from os import environ

parser = argparse.ArgumentParser(
    description="""Сравнивалка workflow в рабочей копии с применённым в IDM.
    Для работы требует указания переменной окружения IDM_SESSION_ID с соответствующей cookie'ой"""
)

parser.parse_args() # чтобы показать 

IDM_SESSION_ID_VAR_NAME = 'IDM_SESSION_ID'
SESSION_ID=environ.get(IDM_SESSION_ID_VAR_NAME)
if SESSION_ID is None or len(SESSION_ID) == 0:
    raise Exception("Please specify IDM Session_id token in " + IDM_SESSION_ID_VAR_NAME + " enviroment variable")

url = "https://idm.yandex-team.ru/idm/api/frontend/systems/direct/workflow/"
r = requests.get(url=url, headers= {"Cookie": "Session_id=" + SESSION_ID})
personal_workflow = r.json()["workflow"]
with open("personal_workflow.py", "r") as f:
    repo_personal_workflow = f.read()

for l in difflib.unified_diff(
    personal_workflow.splitlines(),
    repo_personal_workflow.splitlines(),
    fromfile='idm/personal_workflow.py',
    tofile='local/personal_workflow.py'):
    print("%s" % (l.strip()))

group_workflow = r.json()["group_workflow"]
with open("group_workflow.py", "r") as f:
    repo_group_workflow = f.read()

for l in difflib.unified_diff(
    group_workflow.splitlines(),
    repo_group_workflow.splitlines(),
    fromfile='idm/group_workflow.py',
    tofile='local/group_workflow.py'):
    print("%s" % (l.strip()))
